/**
 * This module provides the course copy modal from the course and
 * category management screen.
 *
 * @module     course
 * @package    core
 * @copyright  2020 onward The Moodle Users Association <https://moodleassociation.org/>
 * @author     Matt Porritt <mattp@catalyst-au.net>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.9
 */
define("core_course/copy_modal",["jquery","core/str","core/modal_factory","core/modal_events","core/ajax","core/fragment","core/notification","core/config"],(function($,Str,ModalFactory,ModalEvents,ajax,Fragment,Notification,Config){var contextid,course,modalObj,CopyModal={},spinner='<p class="text-center"><i class="fa fa-spinner fa-pulse fa-2x fa-fw"></i></p>';function updateModalBody(formdata){void 0===formdata&&(formdata={});var params={jsonformdata:JSON.stringify(formdata),courseid:course.id};modalObj.setBody(spinner),Str.get_string("copycoursetitle","backup",course.shortname).then((function(title){modalObj.setTitle(title),modalObj.setBody(Fragment.loadFragment("course","new_base_form",contextid,params))})).catch((function(){Notification.exception(new Error("Failed to load string: copycoursetitle"))}))}function processModalForm(e){e.preventDefault();var copyform=modalObj.getRoot().find("form").serialize(),formjson=JSON.stringify(copyform),invalid=$.merge(modalObj.getRoot().find('[aria-invalid="true"]'),modalObj.getRoot().find(".error"));invalid.length?invalid.first().focus():ajax.call([{methodname:"core_backup_submit_copy_form",args:{jsonformdata:formjson}}])[0].done((function(){if(modalObj.setBody(spinner),modalObj.hide(),1==e.formredirect){var redirect=Config.wwwroot+"/backup/copyprogress.php?id="+course.id;window.location.assign(redirect)}})).fail((function(){updateModalBody(copyform)}))}return CopyModal.init=function(context){contextid=context,Str.get_string("loading").then((function(title){ModalFactory.create({type:ModalFactory.types.DEFAULT,title:title,body:spinner,large:!0}).done((function(modal){(modalObj=modal).getRoot().on("click","#id_submitreturn",processModalForm),modalObj.getRoot().on("click","#id_submitdisplay",(function(e){e.formredirect=!0,processModalForm(e)})),modalObj.getRoot().on("click","#id_cancel",(function(e){e.preventDefault(),modalObj.setBody(spinner),modalObj.hide()}))}))})).catch((function(){Notification.exception(new Error("Failed to load string: loading"))})),$(".action-copy").on("click",(function(e){e.preventDefault();var url=new URL(this.getAttribute("href")),courseid=new URLSearchParams(url.search).get("id");ajax.call([{methodname:"core_course_get_courses",args:{options:{ids:[courseid]}}}])[0].done((function(response){course=response[0],updateModalBody()})).fail((function(){Notification.exception(new Error("Failed to load course"))})),modalObj.show()}))},CopyModal}));

//# sourceMappingURL=copy_modal.min.js.map