/**
 * Contain the logic for the question bank modal.
 *
 * @module     mod_quiz/modal_quiz_question_bank
 * @package    mod_quiz
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_quiz/modal_quiz_question_bank",["jquery","core/yui","core/notification","core/modal","core/modal_events","core/modal_registry","core/fragment"],(function($,Y,Notification,Modal,ModalEvents,ModalRegistry,Fragment){var registered=!1,SELECTORS_ADD_TO_QUIZ_CONTAINER="td.addtoquizaction",SELECTORS_ANCHOR="a[href]",SELECTORS_PREVIEW_CONTAINER="td.previewaction",SELECTORS_SEARCH_OPTIONS="#advancedsearch",SELECTORS_DISPLAY_OPTIONS="#displayoptions",SELECTORS_ADD_QUESTIONS_FORM='form[action="edit.php"]',ModalQuizQuestionBank=function(root){Modal.call(this,root),this.contextId=null,this.addOnPageId=null};return ModalQuizQuestionBank.TYPE="mod_quiz-quiz-question-bank",(ModalQuizQuestionBank.prototype=Object.create(Modal.prototype)).constructor=ModalQuizQuestionBank,ModalQuizQuestionBank.prototype.setContextId=function(id){this.contextId=id},ModalQuizQuestionBank.prototype.getContextId=function(){return this.contextId},ModalQuizQuestionBank.prototype.setAddOnPageId=function(id){this.addOnPageId=id},ModalQuizQuestionBank.prototype.getAddOnPageId=function(){return this.addOnPageId},ModalQuizQuestionBank.prototype.show=function(){return this.reloadBodyContent(window.location.search),Modal.prototype.show.call(this)},ModalQuizQuestionBank.prototype.reloadBodyContent=function(queryString){var promise=Fragment.loadFragment("mod_quiz","quiz_question_bank",this.getContextId(),{querystring:queryString}).fail(Notification.exception);this.setBody(promise)},ModalQuizQuestionBank.prototype.handleAddToQuizEvent=function(e,anchorElement){var href=anchorElement.attr("href")+"&addonpage="+this.getAddOnPageId();anchorElement.attr("href",href)},ModalQuizQuestionBank.prototype.handlePreviewContainerEvent=function(e,anchorElement){window.openpopup(e,{url:anchorElement.attr("href"),name:"questionpreview",options:["height=600","width=800","top=0","left=0","menubar=0","location=0","scrollbars","resizable","toolbar","status","directories=0","fullscreen=0","dependent"].join(",")})},ModalQuizQuestionBank.prototype.handleDisplayOptionFormEvent=function(e){e.stopPropagation(),e.preventDefault();var queryString="?"+$(e.target).closest(SELECTORS_DISPLAY_OPTIONS).serialize();this.reloadBodyContent(queryString)},ModalQuizQuestionBank.prototype.registerDisplayOptionListeners=function(){this.getModal().on("change",SELECTORS_DISPLAY_OPTIONS,function(e){$(e.target).attr("aria-autocomplete")||this.handleDisplayOptionFormEvent(e)}.bind(this)),this.getModal().on("submit",SELECTORS_DISPLAY_OPTIONS,function(e){this.handleDisplayOptionFormEvent(e)}.bind(this))},ModalQuizQuestionBank.prototype.registerEventListeners=function(){Modal.prototype.registerEventListeners.call(this),this.registerDisplayOptionListeners(),this.getModal().on("submit",SELECTORS_ADD_QUESTIONS_FORM,function(e){var formElement=$(e.currentTarget);$("<input />").attr("type","hidden").attr("name","addonpage").attr("value",this.getAddOnPageId()).appendTo(formElement)}.bind(this)),this.getModal().on("click",SELECTORS_ANCHOR,function(e){var anchorElement=$(e.currentTarget);anchorElement.closest(SELECTORS_ADD_TO_QUIZ_CONTAINER).length?this.handleAddToQuizEvent(e,anchorElement):anchorElement.closest(SELECTORS_PREVIEW_CONTAINER).length?this.handlePreviewContainerEvent(e,anchorElement):anchorElement.closest(SELECTORS_SEARCH_OPTIONS).length||(e.preventDefault(),this.reloadBodyContent(anchorElement.prop("search")))}.bind(this)),this.getRoot().on(ModalEvents.bodyRendered,(function(){Y.use("moodle-core-formchangechecker",(function(){M.core_formchangechecker.reset_form_dirty_state()}))}))},registered||(ModalRegistry.register(ModalQuizQuestionBank.TYPE,ModalQuizQuestionBank,"core/modal"),registered=!0),ModalQuizQuestionBank}));

//# sourceMappingURL=modal_quiz_question_bank.min.js.map