/**
 * Encapsules the behavior for creating a tool type and tool proxy from a
 * registration url in Moodle.
 *
 * Manages the UI while operations are occuring, including rendering external
 * registration page within the iframe.
 *
 * See template: mod_lti/external_registration
 *
 * @module     mod_lti/external_registration
 * @class      external_registration
 * @package    mod_lti
 * @copyright  2015 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.1
 */
define("mod_lti/external_registration",["jquery","core/ajax","core/notification","core/templates","mod_lti/events","mod_lti/tool_proxy","mod_lti/tool_type","mod_lti/keys","core/str"],(function($,ajax,notification,templates,ltiEvents,toolProxy,toolType,KEYS,str){var SELECTORS_EXTERNAL_REGISTRATION_CONTAINER="#external-registration-page-container",SELECTORS_EXTERNAL_REGISTRATION_TEMPLATE_CONTAINER="#external-registration-template-container",SELECTORS_EXTERNAL_REGISTRATION_CANCEL_BUTTON="#cancel-external-registration",SELECTORS_TOOL_TYPE_CAPABILITIES_CONTAINER="#tool-type-capabilities-container",SELECTORS_TOOL_TYPE_CAPABILITIES_TEMPLATE_CONTAINER="#tool-type-capabilities-template-container",SELECTORS_CAPABILITIES_AGREE_CONTAINER=".capabilities-container",getExternalRegistrationCancelButton=function(){return $(SELECTORS_EXTERNAL_REGISTRATION_CANCEL_BUTTON)},getExternalRegistrationContainer=function(){return $(SELECTORS_EXTERNAL_REGISTRATION_CONTAINER)},getExternalRegistrationTemplateContainer=function(){return $(SELECTORS_EXTERNAL_REGISTRATION_TEMPLATE_CONTAINER)},getToolTypeCapabilitiesContainer=function(){return $(SELECTORS_TOOL_TYPE_CAPABILITIES_CONTAINER)},stopLoadingCancel=function(){getExternalRegistrationCancelButton().removeClass("loading")},hideExternalRegistrationContent=function(){getExternalRegistrationContainer().addClass("hidden")},getToolProxyId=function(){return getExternalRegistrationCancelButton().attr("data-tool-proxy-id")},hasToolProxyId=function(){return!!getToolProxyId()},hasCreatedToolProxy=function(){return getExternalRegistrationCancelButton().attr("data-tool-proxy-new")&&hasToolProxyId()},cancelRegistration=function(){getExternalRegistrationCancelButton().addClass("loading");var promise=$.Deferred();if(hasCreatedToolProxy()){var id=getToolProxyId();toolProxy.delete(id).done((function(){promise.resolve()})).fail((function(failure){promise.reject(failure)}))}else promise.resolve();return promise.done((function(){finishExternalRegistration(),stopLoadingCancel()})).fail((function(failure){notification.exception(failure),finishExternalRegistration(),stopLoadingCancel(),str.get_string("failedtodeletetoolproxy","mod_lti").done((function(s){var feedback={message:s,error:!0};$(document).trigger(ltiEvents.REGISTRATION_FEEDBACK,feedback)})).fail(notification.exception)})),promise},renderExternalRegistrationWindow=function(registrationRequest){var promise=templates.render("mod_lti/tool_proxy_registration_form",registrationRequest);return promise.done((function(html,js){var container=getExternalRegistrationTemplateContainer();container.append(html),templates.runTemplateJS(js),container.find("form").submit(),getExternalRegistrationContainer().removeClass("hidden")})).fail(notification.exception),promise},promptForToolTypeCapabilitiesAgreement=function(typeData){var promise=$.Deferred();return templates.render("mod_lti/tool_type_capabilities_agree",typeData).done((function(html,js){var container=$(SELECTORS_TOOL_TYPE_CAPABILITIES_TEMPLATE_CONTAINER);hideExternalRegistrationContent(),getToolTypeCapabilitiesContainer().removeClass("hidden"),templates.replaceNodeContents(container,html,js);var choiceContainer=container.find(SELECTORS_CAPABILITIES_AGREE_CONTAINER);choiceContainer.on(ltiEvents.CAPABILITIES_AGREE,(function(){getToolTypeCapabilitiesContainer().addClass("loading"),function(typeData){return toolType.update({id:typeData.id,state:toolType.constants.state.configured})}(typeData).always((function(){getToolTypeCapabilitiesContainer().removeClass("loading"),container.empty(),promise.resolve()}))})),choiceContainer.on(ltiEvents.CAPABILITIES_DECLINE,(function(){container.empty(),promise.resolve()}))})).fail(promise.reject),promise.done((function(){getToolTypeCapabilitiesContainer().addClass("hidden")})).fail(notification.exception),promise},createAndRegisterToolProxy=function(url){var promise=$.Deferred();return url&&""!==url?toolProxy.create({regurl:url}).done((function(result){getExternalRegistrationCancelButton().attr("data-tool-proxy-new","new"),promise=registerProxy(result.id)})).fail((function(exception){cancelRegistration();var feedback={message:exception.message,error:!0};$(document).trigger(ltiEvents.REGISTRATION_FEEDBACK,feedback),promise.reject(exception)})):promise.resolve(),promise},registerProxy=function(id){var promise=$.Deferred();return function(id){getExternalRegistrationCancelButton().attr("data-tool-proxy-id",id)}(id),function(id){var request={methodname:"mod_lti_get_tool_proxy_registration_request",args:{id:id}};return ajax.call([request])[0]}(id).done((function(registrationRequest){renderExternalRegistrationWindow(registrationRequest).done((function(){promise.resolve()})).fail(promise.fail)})).fail(promise.fail),promise},finishExternalRegistration=function(){hasToolProxyId()&&getExternalRegistrationCancelButton().removeAttr("data-tool-proxy-id"),getExternalRegistrationCancelButton().removeAttr("data-tool-proxy-new"),hideExternalRegistrationContent(),getExternalRegistrationTemplateContainer().empty(),$(document).trigger(ltiEvents.STOP_EXTERNAL_REGISTRATION)};return{init:function(){!function(){$(document).on(ltiEvents.START_EXTERNAL_REGISTRATION,(function(event,data){data&&(data.url&&createAndRegisterToolProxy(data.url),data.proxyid&&registerProxy(data.proxyid))}));var cancelExternalRegistrationButton=getExternalRegistrationCancelButton();cancelExternalRegistrationButton.click((function(e){e.preventDefault(),cancelRegistration()})),cancelExternalRegistrationButton.keypress((function(e){e.metaKey||e.shiftKey||e.altKey||e.ctrlKey||e.keyCode!=KEYS.ENTER&&e.keyCode!=KEYS.SPACE||(e.preventDefault(),cancelRegistration())})),window.triggerExternalRegistrationComplete=function(data){var promise=$.Deferred(),feedback={message:"",error:!1};if("success"==data.status){if(str.get_string("successfullycreatedtooltype","mod_lti").done((function(s){feedback.message=s})).fail(notification.exception),promise.done((function(){finishExternalRegistration(),$(document).trigger(ltiEvents.REGISTRATION_FEEDBACK,feedback),$(document).trigger(ltiEvents.NEW_TOOL_TYPE)})).fail(notification.exception),hasCreatedToolProxy()){var proxyId=getToolProxyId();toolType.getFromToolProxyId(proxyId).done((function(types){if(types&&types.length){var typeData=types[0];typeData.hascapabilitygroups?promptForToolTypeCapabilitiesAgreement(typeData).always((function(){promise.resolve()})):promise.resolve()}else promise.resolve()})).fail((function(){promise.resolve()}))}}else feedback.message=data.error,feedback.error=!0,promise.done((function(){cancelRegistration().always((function(){$(document).trigger(ltiEvents.REGISTRATION_FEEDBACK,feedback)}))})).fail(notification.exception),promise.resolve();return promise}}()}}}));

//# sourceMappingURL=external_registration.min.js.map